document.addEventListener("DOMContentLoaded", function(event) {
    var tcc = document.getElementById('tiny-cookie-consent');
    var tccAccept = tcc.querySelector('[data-action=accept]');
    var tccReject = tcc.querySelector('[data-action=reject]');

    function getCookie(cname) {
        const value = "; " + document.cookie;
        const parts = value.split("; " + cname + "=");
        if (parts.length == 2) return parts.pop().split(";").shift();
    };

    function setCookie(cname, cvalue, exdays) {
        let d = new Date();
        d.setTime(d.getTime() + (exdays*24*60*60*1000));
        const expires = "expires="+ d.toUTCString();
        document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
    }

    function startTrackers() {
        var scripts = tcc.querySelectorAll('script');

        [].map.call(scripts, (script) => {
            // Convert blocked type and src attributes to regular ones
            if (script.hasAttribute('data-type')) {
                script.setAttribute('type', script.getAttribute('data-type'));
                script.removeAttribute('data-type');
            }

            if (script.hasAttribute('data-src')) {
                script.setAttribute('src', script.getAttribute('data-src'));
                script.removeAttribute('data-src');
            }

            // Create a new element based the old one
            var newScript = document.createElement(script.tagName);
            var innerScript = document.createTextNode(script.innerText);
            newScript.appendChild(innerScript);

            // Copy all attributes
            if (script.hasAttributes()) {
                const attrs = script.attributes;
                for (var i = attrs.length - 1; i >= 0; i--) {
                    newScript.setAttribute(attrs[i].name, attrs[i].value);
                }
            }

            // Add it to the end of the page
            document.body.appendChild(newScript);
        });
    }

    var cookieConsent = getCookie('cookieConsent');

    if (cookieConsent == '1') {
      startTrackers();
      return;
    }
    
    if (cookieConsent == undefined) {
        tcc.classList.add('show');

        tccAccept.addEventListener('click', function() {
            tcc.classList.remove('show');
            setCookie('cookieConsent', '1', 14);
            startTrackers();
        });
    
        tccReject.addEventListener('click', function() {
            tcc.classList.remove('show');
            setCookie('cookieConsent', '0', 14);
        });
    }
});